<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>

<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <!-- Small boxes (Stat box) -->
    <div class="row">
      <div class="col">
        <div class="alert alert-info" role="alert">
          Silahkan masukkan tahun awal dan tahun akhir dengan rentang tahun maksimal 10 tahun.<br>
          Pastikan pengisian tahun hanya angka saja
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col">
        <!-- Button trigger modal -->
        <form method="POST" action="cektglpangkat">
          <div class="row g-2">
            <div class="col-md">
              <div class="form-floating">
                <input type="text" class="form-control" id="tahunawal" name="tahunawal" placeholder="Tahun Awal">
                <label for="tahunawal">Tahun Awal</label>
              </div>
            </div>

            <div class="col-md">
              <div class="form-floating">
                <input type="text" class="form-control" id="tahunakhir" name="tahunakhir" placeholder="Tahun Akhir">
                <label for="tahunakhir">Tahun Akhir</label>
              </div>
            </div>
            <button type="submit" id="cekpangkat" class="btn btn-primary">
              Cek Pangkat
            </button>
          </div>

        </form>

        <!-- <button type="button" name="btndeleteabsenpegawai" id="btndeleteabsenpegawai" class="btn btn-danger">Hapus</button>
        <button type="button" id="btnimportabsenbaru" class="btn btn-info" data-toggle="modal" data-target="#importModal">
          Import
        </button> -->

      </div>
    </div>

    <div class="row mt-3">
      <div class="col">
        <div class="table-responsive">
          <table class="table table-striped" id="tableCekPangkat">
            <thead class="bg-navy">
              <tr>

                <th scope="col">No</th>
                <th scope="col">NIP</th>
                <th scope="col">Nama Lengkap</th>


                <?php foreach ($arraytahun as $arraytahunj) : ?>
                  <th scope="col"><?= $arraytahunj; ?></th>

                <?php endforeach; ?>

              </tr>
            </thead>


          </table>
        </div>


      </div>
    </div>




  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script type='text/javascript'>
  var arrayjstahun = <?php echo json_encode($arraytahun); ?>;
  // console.log(array);
  // alert(array);
</script>
<script>
  $(document).ready(function() {

    $('.selectnamalengkap').select2({
      theme: "bootstrap"
    });


    function tabelcekpangkat(dataks) {
      let i = "1";
      $('#tableCekPangkat').DataTable({
        "data": dataks,
        "responsive": true,
        "dom": "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
          "<'row'<'col-sm-12'tr>>" +
          "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        "buttons": [{
            extend: 'copyHtml5',
            text: '<i class="far fa-fw fa-copy"></i>',
            titleAttr: 'Copy'
          },
          {
            extend: 'excelHtml5',
            text: '<i class="far fa-fw fa-file-excel"></i>',
            titleAttr: 'Excel'
          },
          {
            extend: 'pdfHtml5',
            text: '<i class="far fa-fw fa-file-pdf"></i>',
            titleAttr: 'Pdf'
          },
          {
            extend: 'print',
            text: '<i class="fas fa-fw fa-print"></i>',
            titleAttr: 'Print'
          },
          {
            extend: 'colvis',
            text: '',
            titleAttr: 'Colvis'
          }
        ],

        "columns": [{
            "data": null,
            "render": function() {
              return a = i++;
            }
          },


          {
            "data": "nip"
          },
          {
            "data": "nama_lengkap"
          },


          {
            "data": "gol_gaji"
          },



        ],

      });
    }


    //fungsi fetch absen
    function fetchCekPangkat() {
      $.ajax({
        url: '<?= base_url(); ?>/pegawai/fetchcekpangkat',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          let i = "1";
          tabelcekpangkat(data.cekpangkat);
        }
      });
    }

    fetchCekPangkat();

    // #column3_search is a <input type="text"> element
    $('#searchbulan').on('keyup', function() {
      $('#tableAbsenPegawai').DataTable()
        .columns(6)
        .search(this.value)
        .draw();
    });

    $('#searchtahun').on('keyup', function() {
      $('#tableAbsenPegawai').DataTable()
        .columns(7)
        .search(this.value)
        .draw();
    });


  });
</script>


<?= $this->endSection(); ?>